<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
    $config = require __DIR__ . '/../config.php';
    session_name($config['app']['session_name']);
    session_start();
}

function base_url($path = '') {
    $config = require __DIR__ . '/../config.php';
    $base = rtrim($config['app']['base_url'], '/');
    if ($path) $path = '/' . ltrim($path, '/');
    return $base . $path;
}

function e($str) {
    return htmlspecialchars($str, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

function csrf_token() {
    if (empty($_SESSION['csrf'])) {
        $_SESSION['csrf'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf'];
}

function csrf_field() {
    echo '<input type="hidden" name="csrf" value="' . e(csrf_token()) . '">';
}

function check_csrf() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (empty($_POST['csrf']) || !hash_equals($_SESSION['csrf'] ?? '', $_POST['csrf'])) {
            http_response_code(400);
            die('Token CSRF inválido.');
        }
    }
}

function flash($key, $msg = null) {
    if ($msg === null) {
        if (!empty($_SESSION['flash'][$key])) {
            $m = $_SESSION['flash'][$key];
            unset($_SESSION['flash'][$key]);
            return $m;
        }
        return null;
    } else {
        $_SESSION['flash'][$key] = $msg;
    }
}

function require_login() {
    if (empty($_SESSION['user_id'])) {
        header('Location: ' . base_url('index.php?admin=1'));
        exit;
    }
}

function slugify($text) {
    $text = preg_replace('~[\p{Zs}\s]+~u', '-', trim($text));
    $text = iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $text);
    $text = preg_replace('~[^-\w]+~', '', $text);
    $text = trim($text, '-');
    $text = preg_replace('~-+~', '-', $text);
    return strtolower($text ?: 'rifa');
}

function only_digits($s) {
    return preg_replace('/\D+/', '', $s);
}
?>
