<?php
require __DIR__ . '/includes/helpers.php';
require __DIR__ . '/includes/db.php';

// Login / Admin gateway in the same file for simplicity
if (isset($_GET['admin'])) {
  // If no user exists yet, show "create first admin"
  $rs = $mysqli->query("SELECT COUNT(*) AS c FROM users");
  $row = $rs->fetch_assoc();
  $hasUsers = ((int)$row['c']) > 0;

  if ($_SERVER['REQUEST_METHOD'] === 'POST') {
      check_csrf();
      if (!$hasUsers && isset($_POST['name'], $_POST['email'], $_POST['password'])) {
          $stmt = $mysqli->prepare("INSERT INTO users(name,email,password_hash) VALUES(?,?,?)");
          $hash = password_hash($_POST['password'], PASSWORD_DEFAULT);
          $stmt->bind_param('sss', $_POST['name'], $_POST['email'], $hash);
          $stmt->execute();
          flash('ok', 'Usuário admin criado. Faça login.');
          $hasUsers = true;
      } elseif ($hasUsers && isset($_POST['email'], $_POST['password'])) {
          $stmt = $mysqli->prepare("SELECT id, name, password_hash FROM users WHERE email=?");
          $stmt->bind_param('s', $_POST['email']);
          $stmt->execute();
          $res = $stmt->get_result();
          if ($u = $res->fetch_assoc()) {
              if (password_verify($_POST['password'], $u['password_hash'])) {
                  $_SESSION['user_id'] = $u['id'];
                  $_SESSION['user_name'] = $u['name'];
                  header('Location: ' . base_url('index.php?dashboard=1'));
                  exit;
              }
          }
          flash('err', 'Login inválido.');
      }
  }
  ?>
  <!doctype html>
  <html lang="pt-br">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin • Rifa Online</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?= e(base_url('assets/style.css')) ?>">
  </head>
  <body class="bg-slate-100">
    <div class="max-w mt-10">
      <div class="card">
        <h1 class="text-2xl font-bold mb-4"><?= $hasUsers ? 'Entrar no Painel' : 'Criar primeiro Administrador' ?></h1>
        <?php if ($m = flash('ok')): ?>
          <div class="p-3 rounded bg-green-100 text-green-800 mb-4"><?= e($m) ?></div>
        <?php endif; ?>
        <?php if ($m = flash('err')): ?>
          <div class="p-3 rounded bg-red-100 text-red-800 mb-4"><?= e($m) ?></div>
        <?php endif; ?>

        <form method="post" class="grid gap-3">
          <?php csrf_field(); ?>
          <?php if (!$hasUsers): ?>
            <label class="grid gap-1">
              <span>Nome</span>
              <input class="border rounded p-2" name="name" required>
            </label>
          <?php endif; ?>
          <label class="grid gap-1">
            <span>Email</span>
            <input class="border rounded p-2" type="email" name="email" required>
          </label>
          <label class="grid gap-1">
            <span>Senha</span>
            <input class="border rounded p-2" type="password" name="password" required>
          </label>
          <button class="px-4 py-2 rounded bg-blue-600 text-white hover:bg-blue-700 w-max">
            <?= $hasUsers ? 'Entrar' : 'Criar Admin e Entrar' ?>
          </button>
        </form>
        <p class="mt-6 text-sm text-slate-500">Dica: depois de logar, crie a rifa, personalize tema/cores/fundo e gere os números.</p>
      </div>
    </div>
  </body>
  </html>
  <?php
  exit;
}

// Dashboard (admin logado)
if (isset($_GET['dashboard'])) {
    require_login();

    // Actions: create raffle, update design, upload photos, generate numbers, set status
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        check_csrf();
        if (isset($_POST['create_raffle'])) {
            $title = trim($_POST['title']);
            $slug  = slugify($_POST['slug'] ?: $title);
            $theme = trim($_POST['theme'] ?? '');
            $desc  = trim($_POST['description'] ?? '');
            $price = floatval($_POST['price'] ?? 0);
            $color1 = $_POST['color_primary'] ?: '#0ea5e9';
            $color2 = $_POST['color_secondary'] ?: '#0369a1';
            $bg_type = $_POST['bg_type'] ?? 'color';
            $bg_value = $_POST['bg_value'] ?? '#f1f5f9';

            $stmt = $mysqli->prepare("INSERT INTO raffles(slug,title,theme,description,price,color_primary,color_secondary,bg_type,bg_value) VALUES(?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('ssssddsss', $slug, $title, $theme, $desc, $price, $color1, $color2, $bg_type, $bg_value);
            if (!$stmt->execute()) {
                flash('err', 'Erro ao criar rifa: ' . $stmt->error);
            } else {
                $raffle_id = $stmt->insert_id;
                // upload photos
                if (!empty($_FILES['photos']['name'][0])) {
                    $config = require __DIR__ . '/config.php';
                    $dir = $config['app']['upload_dir'];
                    if (!is_dir($dir)) mkdir($dir, 0777, true);
                    for ($i=0; $i<count($_FILES['photos']['name']); $i++) {
                        if ($_FILES['photos']['error'][$i] === UPLOAD_ERR_OK) {
                            $tmp = $_FILES['photos']['tmp_name'][$i];
                            $ext = strtolower(pathinfo($_FILES['photos']['name'][$i], PATHINFO_EXTENSION));
                            if (!in_array($ext, ['jpg','jpeg','png','webp'])) continue;
                            $fn = 'raffle_' . $raffle_id . '_' . bin2hex(random_bytes(5)) . '.' . $ext;
                            $dest = $dir . '/' . $fn;
                            if (move_uploaded_file($tmp, $dest)) {
                                $s2 = $mysqli->prepare("INSERT INTO raffle_photos(raffle_id, filename) VALUES(?,?)");
                                $s2->bind_param('is', $raffle_id, $fn);
                                $s2->execute();
                            }
                        }
                    }
                }
                // generate numbers (1..N)
                $count = max(1, (int)($_POST['numbers_count'] ?? 100));
                $s3 = $mysqli->prepare("INSERT INTO numbers(raffle_id, number) VALUES(?, ?)");
                for ($n=1; $n <= $count; $n++) {
                    $s3->bind_param('ii', $raffle_id, $n);
                    $s3->execute();
                }
                flash('ok', 'Rifa criada com sucesso!');
            }
        }

        if (isset($_POST['design_update'])) {
            $rid = (int)$_POST['raffle_id'];
            $stmt = $mysqli->prepare("UPDATE raffles SET title=?, theme=?, description=?, price=?, color_primary=?, color_secondary=?, bg_type=?, bg_value=? WHERE id=?");
            $stmt->bind_param('sssddsssi',
                $_POST['title'], $_POST['theme'], $_POST['description'], $_POST['price'],
                $_POST['color_primary'], $_POST['color_secondary'], $_POST['bg_type'], $_POST['bg_value'],
                $rid
            );
            $stmt->execute();
            flash('ok', 'Tema/cores/fundo atualizados.');
        }

        if (isset($_POST['photo_upload'])) {
            $rid = (int)$_POST['raffle_id'];
            if (!empty($_FILES['photos']['name'][0])) {
                $config = require __DIR__ . '/config.php';
                $dir = $config['app']['upload_dir'];
                if (!is_dir($dir)) mkdir($dir, 0777, true);
                for ($i=0; $i<count($_FILES['photos']['name']); $i++) {
                    if ($_FILES['photos']['error'][$i] === UPLOAD_ERR_OK) {
                        $tmp = $_FILES['photos']['tmp_name'][$i];
                        $ext = strtolower(pathinfo($_FILES['photos']['name'][$i], PATHINFO_EXTENSION));
                        if (!in_array($ext, ['jpg','jpeg','png','webp'])) continue;
                        $fn = 'raffle_' . $rid . '_' . bin2hex(random_bytes(5)) . '.' . $ext;
                        $dest = $dir . '/' . $fn;
                        if (move_uploaded_file($tmp, $dest)) {
                            $s2 = $mysqli->prepare("INSERT INTO raffle_photos(raffle_id, filename) VALUES(?,?)");
                            $s2->bind_param('is', $rid, $fn);
                            $s2->execute();
                        }
                    }
                }
                flash('ok', 'Foto(s) enviada(s).');
            }
        }

        if (isset($_POST['status_update'])) {
            $rid = (int)$_POST['raffle_id'];
            $num = (int)$_POST['number'];
            $status = $_POST['status'];
            $holder_name = $_POST['holder_name'] ?? null;
            $holder_phone = $_POST['holder_phone'] ?? null;
            $stmt = $mysqli->prepare("UPDATE numbers SET status=?, holder_name=?, holder_phone=?, updated_at=NOW() WHERE raffle_id=? AND number=?");
            $stmt->bind_param('sssii', $status, $holder_name, $holder_phone, $rid, $num);
            $stmt->execute();
            flash('ok', 'Status do número atualizado.');
        }

        if (isset($_POST['export_csv'])) {
            $rid = (int)$_POST['raffle_id'];
            header('Content-Type: text/csv; charset=utf-8');
            header('Content-Disposition: attachment; filename=rifa_' . $rid . '_numeros.csv');
            $out = fopen('php://output', 'w');
            fputcsv($out, ['numero','status','nome','telefone','atualizado_em']);
            $q = $mysqli->prepare("SELECT number,status,holder_name,holder_phone,updated_at FROM numbers WHERE raffle_id=? ORDER BY number ASC");
            $q->bind_param('i', $rid);
            $q->execute();
            $rs = $q->get_result();
            while ($r = $rs->fetch_row()) fputcsv($out, $r);
            fclose($out);
            exit;
        }
    }

    // Data for dashboard
    $raffles = $mysqli->query("SELECT * FROM raffles ORDER BY id DESC");
    $currentRaffle = null;
    if (isset($_GET['r'])) {
        $rslug = $_GET['r'];
        $s = $mysqli->prepare("SELECT * FROM raffles WHERE slug=?");
        $s->bind_param('s', $rslug);
        $s->execute();
        $currentRaffle = $s->get_result()->fetch_assoc();
    } else {
        $currentRaffle = $mysqli->query("SELECT * FROM raffles ORDER BY id DESC LIMIT 1")->fetch_assoc();
    }
    $numbers = [];
    if ($currentRaffle) {
        $rid = (int)$currentRaffle['id'];
        $rs = $mysqli->query("SELECT * FROM numbers WHERE raffle_id={$rid} ORDER BY number ASC");
        $numbers = $rs->fetch_all(MYSQLI_ASSOC);
        $photos = $mysqli->query("SELECT * FROM raffle_photos WHERE raffle_id={$rid} ORDER BY id DESC")->fetch_all(MYSQLI_ASSOC);
    } else {
        $photos = [];
    }

    ?>
    <!doctype html>
    <html lang="pt-br">
    <head>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <title>Painel • Rifa Online</title>
      <script src="https://cdn.tailwindcss.com"></script>
      <link rel="stylesheet" href="<?= e(base_url('assets/style.css')) ?>">
    </head>
    <body class="bg-slate-100">
      <div class="max-w mt-8">
        <div class="flex justify-between items-center mb-4">
          <h1 class="text-2xl font-bold">Painel da Rifa</h1>
          <a class="text-blue-700 underline" href="<?= e(base_url()) ?>">Ver página pública</a>
        </div>
        <?php if ($m = flash('ok')): ?>
          <div class="p-3 rounded bg-green-100 text-green-800 mb-4"><?= e($m) ?></div>
        <?php endif; ?>
        <?php if ($m = flash('err')): ?>
          <div class="p-3 rounded bg-red-100 text-red-800 mb-4"><?= e($m) ?></div>
        <?php endif; ?>

        <div class="grid md:grid-cols-2 gap-6">
          <div class="card">
            <h2 class="font-semibold text-xl mb-2">Criar nova rifa</h2>
            <form method="post" enctype="multipart/form-data" class="grid gap-2">
              <?php csrf_field(); ?>
              <input type="hidden" name="create_raffle" value="1">
              <label class="grid gap-1">
                <span>Título / Nome da rifa</span>
                <input class="border rounded p-2" name="title" required>
              </label>
              <label class="grid gap-1">
                <span>Slug (URL amigável) — deixe em branco para gerar automaticamente</span>
                <input class="border rounded p-2" name="slug">
              </label>
              <label class="grid gap-1">
                <span>Tema</span>
                <input class="border rounded p-2" name="theme" placeholder="Ex.: Dia das Mães, Gamer, Pet Shop...">
              </label>
              <label class="grid gap-1">
                <span>Descrição</span>
                <textarea class="border rounded p-2" name="description" rows="3"></textarea>
              </label>
              <div class="grid grid-cols-3 gap-2">
                <label class="grid gap-1">
                  <span>Preço</span>
                  <input class="border rounded p-2" type="number" step="0.01" name="price" value="0.00">
                </label>
                <label class="grid gap-1">
                  <span>Nº de cotas</span>
                  <input class="border rounded p-2" type="number" name="numbers_count" value="100" min="1" max="10000">
                </label>
              </div>
              <div class="grid grid-cols-2 gap-2">
                <label class="grid gap-1">
                  <span>Cor primária</span>
                  <input class="border rounded p-2" type="color" name="color_primary" value="#0ea5e9">
                </label>
                <label class="grid gap-1">
                  <span>Cor secundária</span>
                  <input class="border rounded p-2" type="color" name="color_secondary" value="#0369a1">
                </label>
              </div>
              <div class="grid grid-cols-2 gap-2">
                <label class="grid gap-1">
                  <span>Fundo (tipo)</span>
                  <select class="border rounded p-2" name="bg_type">
                    <option value="color">Cor</option>
                    <option value="image">Imagem</option>
                  </select>
                </label>
                <label class="grid gap-1">
                  <span>Valor do fundo (hex ou upload ao lado)</span>
                  <input class="border rounded p-2" name="bg_value" value="#f1f5f9">
                </label>
              </div>
              <label class="grid gap-1">
                <span>Fotos / prêmios / mimos (múltiplas)</span>
                <input class="border rounded p-2" type="file" name="photos[]" accept=".jpg,.jpeg,.png,.webp" multiple>
              </label>

              <button class="mt-2 px-4 py-2 rounded bg-blue-600 text-white hover:bg-blue-700 w-max">Criar rifa</button>
            </form>
          </div>

          <div class="card">
            <h2 class="font-semibold text-xl mb-2">Rifas existentes</h2>
            <div class="space-y-2 max-h-[420px] overflow-auto">
              <?php while ($r = $raffles->fetch_assoc()): ?>
                <div class="p-2 border rounded flex justify-between items-center">
                  <div>
                    <div class="font-semibold"><?= e($r['title']) ?></div>
                    <div class="text-sm text-slate-500">/<?= e($r['slug']) ?> • <?= $r['is_active'] ? 'Ativa' : 'Inativa' ?></div>
                  </div>
                  <a class="text-blue-700 underline" href="<?= e(base_url('index.php?dashboard=1&r='.$r['slug'])) ?>">gerenciar</a>
                </div>
              <?php endwhile; ?>
            </div>
          </div>
        </div>

        <?php if ($currentRaffle): ?>
          <div class="card mt-6">
            <div class="flex justify-between items-center">
              <h2 class="font-semibold text-xl">Gerenciar: <?= e($currentRaffle['title']) ?> (<?= e($currentRaffle['slug']) ?>)</h2>
              <a class="text-blue-700 underline" target="_blank" href="<?= e(base_url('?r='.$currentRaffle['slug'])) ?>">ver pública</a>
            </div>

            <div class="grid md:grid-cols-2 gap-6 mt-4">
              <div>
                <h3 class="font-semibold mb-2">Tema / cores / fundo</h3>
                <form method="post" class="grid gap-2">
                  <?php csrf_field(); ?>
                  <input type="hidden" name="design_update" value="1">
                  <input type="hidden" name="raffle_id" value="<?= (int)$currentRaffle['id'] ?>">
                  <label class="grid gap-1">
                    <span>Título</span>
                    <input class="border rounded p-2" name="title" value="<?= e($currentRaffle['title']) ?>">
                  </label>
                  <label class="grid gap-1">
                    <span>Tema</span>
                    <input class="border rounded p-2" name="theme" value="<?= e($currentRaffle['theme']) ?>">
                  </label>
                  <label class="grid gap-1">
                    <span>Descrição</span>
                    <textarea class="border rounded p-2" name="description" rows="3"><?= e($currentRaffle['description']) ?></textarea>
                  </label>
                  <div class="grid grid-cols-2 gap-2">
                    <label class="grid gap-1">
                      <span>Preço</span>
                      <input class="border rounded p-2" name="price" type="number" step="0.01" value="<?= e($currentRaffle['price']) ?>">
                    </label>
                    <label class="grid gap-1">
                      <span>Cor primária</span>
                      <input class="border rounded p-2" name="color_primary" type="color" value="<?= e($currentRaffle['color_primary']) ?>">
                    </label>
                    <label class="grid gap-1">
                      <span>Cor secundária</span>
                      <input class="border rounded p-2" name="color_secondary" type="color" value="<?= e($currentRaffle['color_secondary']) ?>">
                    </label>
                  </div>
                  <div class="grid grid-cols-2 gap-2">
                    <label class="grid gap-1">
                      <span>Fundo (tipo)</span>
                      <select class="border rounded p-2" name="bg_type">
                        <option value="color" <?= $currentRaffle['bg_type']==='color'?'selected':'' ?>>Cor</option>
                        <option value="image" <?= $currentRaffle['bg_type']==='image'?'selected':'' ?>>Imagem</option>
                      </select>
                    </label>
                    <label class="grid gap-1">
                      <span>Valor do fundo</span>
                      <input class="border rounded p-2" name="bg_value" value="<?= e($currentRaffle['bg_value']) ?>">
                    </label>
                  </div>
                  <button class="mt-1 px-4 py-2 rounded bg-blue-600 text-white">Salvar</button>
                </form>
              </div>

              <div>
                <h3 class="font-semibold mb-2">Fotos / prêmios / mimos</h3>
                <form method="post" enctype="multipart/form-data" class="grid gap-2">
                  <?php csrf_field(); ?>
                  <input type="hidden" name="photo_upload" value="1">
                  <input type="hidden" name="raffle_id" value="<?= (int)$currentRaffle['id'] ?>">
                  <input class="border rounded p-2" type="file" name="photos[]" accept=".jpg,.jpeg,.png,.webp" multiple>
                  <button class="px-4 py-2 rounded bg-blue-600 text-white w-max">Enviar</button>
                </form>
                <div class="grid grid-cols-3 gap-2 mt-3">
                  <?php foreach ($photos as $p): ?>
                    <img class="rounded-lg border" src="<?= e(base_url('uploads/'.$p['filename'])) ?>" alt="foto">
                  <?php endforeach; ?>
                </div>
              </div>
            </div>

            <div class="mt-6">
              <h3 class="font-semibold mb-2">Números</h3>
              <form method="post" class="flex flex-wrap gap-2 items-end">
                <?php csrf_field(); ?>
                <input type="hidden" name="status_update" value="1">
                <input type="hidden" name="raffle_id" value="<?= (int)$currentRaffle['id'] ?>">
                <label class="grid gap-1">
                  <span>Número</span>
                  <input class="border rounded p-2 w-24" type="number" name="number" min="1">
                </label>
                <label class="grid gap-1">
                  <span>Status</span>
                  <select class="border rounded p-2" name="status">
                    <option value="livre">livre</option>
                    <option value="reservado">reservado</option>
                    <option value="pago">pago</option>
                  </select>
                </label>
                <label class="grid gap-1">
                  <span>Nome</span>
                  <input class="border rounded p-2" name="holder_name">
                </label>
                <label class="grid gap-1">
                  <span>Telefone</span>
                  <input class="border rounded p-2" name="holder_phone">
                </label>
                <button class="px-4 py-2 rounded bg-blue-600 text-white">Atualizar</button>
                <button name="export_csv" value="1" class="px-4 py-2 rounded bg-slate-700 text-white">Exportar CSV</button>
              </form>

              <div class="grid-numbers mt-4">
                <?php foreach ($numbers as $n): ?>
                  <div class="num <?= e($n['status']) ?>">
                    <div><?= (int)$n['number'] ?></div>
                    <div class="text-xs text-slate-500">
                      <?php if ($n['status']==='livre'): ?>
                        <span class="badge badge-livre">livre</span>
                      <?php elseif ($n['status']==='reservado'): ?>
                        <span class="badge badge-reservado">reservado</span>
                      <?php else: ?>
                        <span class="badge badge-pago">pago</span>
                      <?php endif; ?>
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>
        <?php endif; ?>
      </div>
    </body>
    </html>
    <?php
    exit;
}

// Página pública da rifa
$slug = $_GET['r'] ?? null;
if ($slug) {
  $stmt = $mysqli->prepare("SELECT * FROM raffles WHERE slug=? AND is_active=1");
  $stmt->bind_param('s', $slug);
  $stmt->execute();
  $raffle = $stmt->get_result()->fetch_assoc();
} else {
  $raffle = $mysqli->query("SELECT * FROM raffles WHERE is_active=1 ORDER BY id DESC LIMIT 1")->fetch_assoc();
}

if (!$raffle) {
  http_response_code(404);
  echo "<!doctype html><meta charset='utf-8'><link rel='stylesheet' href='https://cdn.jsdelivr.net/npm/tailwindcss@3.4.4/dist/tailwind.min.css'><div class='p-6 max-w mx-auto'><div class='card'><h1 class='text-xl font-bold'>Nenhuma rifa ativa</h1><p class='mt-2'>Crie uma no painel <a class='text-blue-700 underline' href='".e(base_url('index.php?admin=1'))."'>admin</a>.</p></div></div>";
  exit;
}

$rid = (int)$raffle['id'];
$photos = $mysqli->query("SELECT * FROM raffle_photos WHERE raffle_id={$rid} ORDER BY id DESC")->fetch_all(MYSQLI_ASSOC);
$nums = $mysqli->query("SELECT number,status FROM numbers WHERE raffle_id={$rid} ORDER BY number ASC")->fetch_all(MYSQLI_ASSOC);

$bg_style = $raffle['bg_type'] === 'image'
  ? "background-image:url('".e(base_url('uploads/'.$raffle['bg_value']))."'); background-size:cover; background-position:center;"
  : "background: ".e($raffle['bg_value']).";";
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= e($raffle['title']) ?> • Rifa</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="<?= e(base_url('assets/style.css')) ?>">
  <style>
    :root{
      --primary: <?= e($raffle['color_primary']) ?>;
      --secondary: <?= e($raffle['color_secondary']) ?>;
    }
    .btn-primary { background: var(--primary); color:white; }
    .btn-primary:hover { filter: brightness(0.95); }
    .hero { <?= $bg_style ?> }
  </style>
</head>
<body class="bg-slate-100">
  <header class="hero max-w mt-4">
    <div class="flex items-center justify-between">
      <div>
        <div class="text-sm uppercase tracking-wide text-slate-600"><?= e($raffle['theme']) ?></div>
        <h1 class="text-3xl md:text-4xl font-extrabold"><?= e($raffle['title']) ?></h1>
        <?php if ($raffle['price'] > 0): ?>
          <div class="mt-1 text-slate-700">Valor da cota: <span class="font-semibold">R$ <?= number_format($raffle['price'],2,',','.') ?></span></div>
        <?php endif; ?>
      </div>
      <a class="px-4 py-2 rounded btn-primary" href="<?= e(base_url('index.php?dashboard=1&r='.$raffle['slug'])) ?>">Área do Organizador</a>
    </div>
    <?php if (!empty($raffle['description'])): ?>
      <p class="mt-3 max-w-prose"><?= nl2br(e($raffle['description'])) ?></p>
    <?php endif; ?>
  </header>

  <main class="max-w mt-6 grid md:grid-cols-3 gap-6">
    <section class="md:col-span-2">
      <div class="card">
        <h2 class="font-semibold text-lg mb-2">Produtos, prêmios e mimos</h2>
        <?php if ($photos): ?>
          <div class="grid grid-cols-2 md:grid-cols-3 gap-3">
            <?php foreach ($photos as $p): ?>
              <img class="rounded-xl border" src="<?= e(base_url('uploads/'.$p['filename'])) ?>" alt="foto">
            <?php endforeach; ?>
          </div>
        <?php else: ?>
          <p class="text-slate-500">Sem fotos cadastradas ainda.</p>
        <?php endif; ?>
      </div>

      <div class="card mt-4">
        <div class="flex items-center justify-between mb-2">
          <h2 class="font-semibold text-lg">Escolha seu número</h2>
          <div class="text-sm text-slate-600">
            <span class="badge badge-livre">livre</span>
            <span class="badge badge-reservado">reservado</span>
            <span class="badge badge-pago">pago</span>
          </div>
        </div>
        <div class="grid-numbers" id="grid">
          <?php foreach ($nums as $n): 
              $cls = e($n['status']);
              $disabled = $n['status'] !== 'livre' ? 'disabled' : '';
          ?>
            <button class="num <?= $cls ?> <?= $disabled ? 'disabled' : '' ?>" data-number="<?= (int)$n['number'] ?>" <?= $disabled ?>><?= (int)$n['number'] ?></button>
          <?php endforeach; ?>
        </div>
      </div>
    </section>

    <aside>
      <div class="card sticky top-4">
        <h2 class="font-semibold text-lg mb-2">Finalize sua reserva</h2>
        <?php if ($m = flash('ok')): ?>
          <div class="p-3 rounded bg-green-100 text-green-800 mb-2"><?= e($m) ?></div>
        <?php endif; ?>
        <?php if ($m = flash('err')): ?>
          <div class="p-3 rounded bg-red-100 text-red-800 mb-2"><?= e($m) ?></div>
        <?php endif; ?>
        <form id="buyForm" method="post" action="<?= e(base_url('pick.php')) ?>" class="grid gap-2">
          <input type="hidden" name="raffle_id" value="<?= (int)$raffle['id'] ?>">
          <input type="hidden" name="number" id="numberField">
          <?php csrf_field(); ?>
          <label class="grid gap-1">
            <span>Seu nome</span>
            <input class="border rounded p-2" name="holder_name" required>
          </label>
          <label class="grid gap-1">
            <span>Telefone (WhatsApp)</span>
            <input class="border rounded p-2" name="holder_phone" required placeholder="(00) 00000-0000">
          </label>
          <button class="px-4 py-2 rounded btn-primary" id="reserveBtn" disabled>Reservar número</button>
          <p class="text-sm text-slate-500">A reserva marca como “reservado”. O organizador poderá confirmar pagamento posteriormente.</p>
        </form>
      </div>
    </aside>
  </main>

  <footer class="max-w mt-10 mb-8">
    <div class="text-center text-slate-500">Feito com ♥ — <a class="underline" href="<?= e(base_url('index.php?admin=1')) ?>">Organizar minha rifa</a></div>
  </footer>

  <script>
    const grid = document.getElementById('grid');
    const numberField = document.getElementById('numberField');
    const reserveBtn = document.getElementById('reserveBtn');
    grid?.addEventListener('click', (e) => {
      const btn = e.target.closest('button.num');
      if (!btn || btn.classList.contains('disabled')) return;
      numberField.value = btn.dataset.number;
      reserveBtn.disabled = false;
      document.querySelectorAll('.num.selected')?.forEach(el => el.classList.remove('ring-2','ring-blue-500','selected'));
      btn.classList.add('ring-2','ring-blue-500','selected');
    });
  </script>
</body>
</html>
