<?php
require __DIR__ . '/includes/helpers.php';
require __DIR__ . '/includes/db.php';

check_csrf();

$raffle_id = (int)($_POST['raffle_id'] ?? 0);
$number    = (int)($_POST['number'] ?? 0);
$name      = trim($_POST['holder_name'] ?? '');
$phone     = trim($_POST['holder_phone'] ?? '');

if (!$raffle_id || !$number || !$name || !$phone) {
    flash('err','Preencha todos os campos e selecione um número.');
    header('Location: ' . base_url());
    exit;
}

// valida telefone simples
$phoneDigits = preg_replace('/\D+/', '', $phone);
if (strlen($phoneDigits) < 10 || strlen($phoneDigits) > 12) {
    flash('err','Telefone inválido.');
    header('Location: ' . base_url('?r=' . ($_GET['r'] ?? '')));
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'] ?? null;

// Tenta reservar: update só se status=livre (evita corrida)
$stmt = $mysqli->prepare("UPDATE numbers SET status='reservado', holder_name=?, holder_phone=?, reserved_by_ip=?, updated_at=NOW() WHERE raffle_id=? AND number=? AND status='livre'");
$stmt->bind_param('sssii', $name, $phoneDigits, $ip, $raffle_id, $number);
$stmt->execute();

if ($stmt->affected_rows > 0) {
    flash('ok','Número ' . $number . ' reservado com sucesso! Aguarde contato do organizador.');
} else {
    flash('err','Ops! Este número acabou de ser escolhido por outra pessoa. Tente outro.');
}

$slug = $mysqli->query("SELECT slug FROM raffles WHERE id={$raffle_id}")->fetch_assoc()['slug'] ?? '';
header('Location: ' . base_url('?r=' . $slug));
exit;
