# Rifa Online (PHP + MySQL)

Projeto simples e pronto para uso para criar rifas online com **tema, nome, fotos, cores e fundo**, exibição de **produtos/prêmios/mimos**, e **escolha de números pelo público** (apenas nome e telefone). Possui **painel do organizador** com usuário/senha para criar e administrar rifas e números.

## Requisitos
- PHP 8.0+ com mysqli e file_uploads habilitados
- MySQL 5.7+ ou MariaDB 10+
- Servidor web (Apache ou Nginx). Tailwind é carregado via CDN.

## Instalação rápida
1. Crie o banco e tabelas:
   ```sql
   SOURCE db.sql;
   ```

2. Copie a pasta `rifa_online` para o seu servidor (ex.: `htdocs` ou `public_html`).

3. Edite `config.php` e ajuste as credenciais do banco e `base_url` (sem barra no final).
   - Certifique-se de dar permissão de escrita em `uploads/`.

4. Acesse `http://SEU_DOMINIO/rifa_online/index.php?admin=1` para **criar o primeiro administrador** e **fazer login**.

5. No painel:
   - Crie uma nova rifa (título, tema, descrição, preço, quantidade de cotas, cores e fundo).
   - Envie fotos (produtos/prêmios/mimos).
   - O sistema gera os números automaticamente (1..N).

6. Divulgue o link público da rifa: `http://SEU_DOMINIO/rifa_online/?r=SLUG-DA-RIFA`
   - O público só preenche **nome** e **telefone** e **escolhe o número** (status ficará **reservado**).
   - No painel, você pode marcar como **pago** ou **livre** novamente e **exportar CSV**.

## Estrutura
```
rifa_online/
  assets/
    style.css
  includes/
    db.php
    helpers.php
  uploads/            (armazenamento de imagens enviadas)
  config.php
  db.sql
  index.php           (página pública + login/admin gateway)
  pick.php            (processa a reserva do número)
```

## Segurança básica
- Senhas com `password_hash`.
- Sessão nomeada e CSRF token em formulários.
- Uploads restritos a imagens (`jpg/jpeg/png/webp`), nome aleatório.
- Reserva de número com update condicional (evita corrida).

## Dicas
- Para fundo com **imagem**, suba a imagem nas fotos e depois, no painel, coloque o nome do arquivo em **Valor do fundo** e selecione **Imagem** no tipo.
- Você pode ter várias rifas: crie novas e acesse por `?r=slug`.
- Para integrar **PIX** futuramente, basta criar uma etapa de pagamento e, quando pago, marcar “pago” no painel.

---

Feito em 2025-08-28.
